﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateCapaRootCauseMethodologyCommandHandler(
        ICapaRootCauseMethodologyRepository _capaRootCauseMethodologyRepository,
        IUnitOfWork<QMSDbContext> _uow,
        IMapper _mapper,
        ILogger<UpdateCapaRootCauseMethodologyCommandHandler> logger) : IRequestHandler<UpdateCapaRootCauseMethodologyCommand, ServiceResponse<CapaRootCauseMethodologyDto>>
    {
        public async Task<ServiceResponse<CapaRootCauseMethodologyDto>> Handle(UpdateCapaRootCauseMethodologyCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var existingName = await _capaRootCauseMethodologyRepository.
                    All.Where(c => c.Id != request.Id && c.Name.ToLower() == request.Name.ToLower()).FirstOrDefaultAsync();
                if (existingName != null)
                {
                    return ServiceResponse<CapaRootCauseMethodologyDto>.Return409("CapaRootCauseMethodology name is already exist");
                }
                var existingEntity = await _capaRootCauseMethodologyRepository.FindAsync(request.Id);
                if (existingEntity == null)
                {
                    return ServiceResponse<CapaRootCauseMethodologyDto>.Return409("CapaRootCauseMethodology does not exists.");
                }

                var entity = _mapper.Map<CapaRootCauseMethodology>(request);
                _capaRootCauseMethodologyRepository.Update(entity);
                if (await _uow.SaveAsync(cancellationToken) <= 0)
                {
                    return ServiceResponse<CapaRootCauseMethodologyDto>.Return500();
                }
                var entityDto = _mapper.Map<CapaRootCauseMethodologyDto>(entity);
                return ServiceResponse<CapaRootCauseMethodologyDto>.ReturnResultWith201(entityDto);
            }

            catch (Exception ex)
            {
                logger.LogError(ex, "Error while updating CapaRootCauseMethodology.");
                return ServiceResponse<CapaRootCauseMethodologyDto>.Return500("Error while updating CapaRootCauseMethodology.");
            }

        }
    }
}
