﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateCapaRootCauseMethodologyCommandValidator:AbstractValidator<UpdateCapaRootCauseMethodologyCommand>
    {
        public UpdateCapaRootCauseMethodologyCommandValidator()
        {
            RuleFor(c => c.Name).NotEmpty().WithMessage("Name is required");
            RuleFor(c => c.Id).Must(NotEmptyGuid).WithMessage("id is required");

        }
        private bool NotEmptyGuid(Guid p)
        {
            return p != Guid.Empty;
        }
    }
}
