﻿using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteCapaRootCauseCommandHandler(
        ICapaRootCauseRepository _capaRootCauseRepository,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<DeleteCapaRootCauseCommandHandler> _logger) : IRequestHandler<DeleteCapaRootCauseCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteCapaRootCauseCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entityExist = await _capaRootCauseRepository.FindAsync(request.Id);
                if (entityExist == null)
                {
                    return ServiceResponse<bool>.Return404("CapaRootCause not found");
                }
                _capaRootCauseRepository.Remove(entityExist);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }

            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while deleting CapaRootCause");
                return ServiceResponse<bool>.Return500("Error while deleting CapaRootCause");
            }

        }
    }
}
