﻿using AutoMapper;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateCapaRootCauseCommandHandler(
        ICapaRootCauseRepository _capaRootCauseRepository,
        ICapaRequestRepository _capaRequestRepository,
        IMapper _mapper,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<UpdateCapaRequestCommandHandler> _logger) : IRequestHandler<UpdateCapaRootCauseCommand, ServiceResponse<CapaRootCauseDto>>
    {
        public async Task<ServiceResponse<CapaRootCauseDto>> Handle(UpdateCapaRootCauseCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var existEntity = await _capaRootCauseRepository.FindAsync(request.Id);
                if (existEntity == null)
                {
                    return ServiceResponse<CapaRootCauseDto>.Return404("CapaRootCause not found");
                }
                var capaExist = await _capaRequestRepository.FindAsync(request.CapaRequestId);
                if (capaExist == null)
                {
                    return ServiceResponse<CapaRootCauseDto>.Return404("CapaRequest not Found");
                }
                existEntity = _mapper.Map(request, existEntity);


                _capaRootCauseRepository.Update(existEntity);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<CapaRootCauseDto>.Return500();
                }
                var entityDto = _mapper.Map<CapaRootCauseDto>(existEntity);
                return ServiceResponse<CapaRootCauseDto>.ReturnResultWith200(entityDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while Updating CapaRootCause");
                return ServiceResponse<CapaRootCauseDto>.Return500("Error while Updating CapaRootCause");
            }

        }
    }
}
