﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetCategoriesHierarchicalBChildIdWindowSharedCommandHandler(ICategoryRepository categoryRepository, IMapper mapper) : IRequestHandler<GetCategoriesHierarchicalBChildIdWindowSharedCommand, ServiceResponse<List<CategoryDto>>>
{
    public async Task<ServiceResponse<List<CategoryDto>>> Handle(GetCategoriesHierarchicalBChildIdWindowSharedCommand request, CancellationToken cancellationToken)
    {

        var hierarchy = new List<CategoryDto>();

        var category = await categoryRepository.All.Where(c => c.IsArchive && c.Id == request.Id).FirstOrDefaultAsync();
        var level = 0;
        while (category != null)
        {
            var categoryDto = mapper.Map<CategoryDto>(category);
            categoryDto.Level = level;
            hierarchy.Add(categoryDto);
            level++;
            if (category.ParentId == null)
                break;

            category = await categoryRepository.FindAsync(category.ParentId.Value);
        }

        return ServiceResponse<List<CategoryDto>>.ReturnResultWith200(hierarchy.OrderByDescending(c => c.Level).ToList());
    }

}

