﻿using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;


namespace QualityManagement.MediatR
{
    public class CheckShareUserByCategoryCommandHandler(ICategoryRepository categoryRepository, IUserRepository _userRepository, UserInfoToken _userInfo) : IRequestHandler<CheckShareUserByCategoryCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(CheckShareUserByCategoryCommand request, CancellationToken cancellationToken)
        {
            var today = DateTime.UtcNow;
            var user = await _userRepository.AllIncluding(c => c.UserRoles).FirstOrDefaultAsync(c => c.Id == _userInfo.Id);
            var userRoles = user.UserRoles.Select(c => c.RoleId).ToList();
            var flag = await categoryRepository.AllIncluding(c => c.CategoryUserPermissions, c => c.CategoryRolePermissions)
                                        .AnyAsync(d => d.Id == request.CategoryId && (d.CategoryUserPermissions.Any(c => c.UserId == user.Id && (!c.IsTimeBound || c.IsTimeBound && c.StartDate < today && c.EndDate > today))
                                                    || d.CategoryRolePermissions.Any(c => userRoles.Contains(c.RoleId) && (!c.IsTimeBound || c.IsTimeBound && c.StartDate < today && c.EndDate > today))));
            return ServiceResponse<bool>.ReturnResultWith200(flag);
        }
    }
}
