﻿using AutoMapper;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddClientCommandHandler(IClientRepository _clientRepository, IMapper _mapper, IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<AddClientCommand, ServiceResponse<ClientDto>>
    {
        public async Task<ServiceResponse<ClientDto>> Handle(AddClientCommand request, CancellationToken cancellationToken)
        {
            var entity = _mapper.Map<Client>(request);
            entity.Id = Guid.NewGuid();
            _clientRepository.Add(entity);
            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<ClientDto>.Return500();
            }
            var entityDto = _mapper.Map<ClientDto>(entity);
            return ServiceResponse<ClientDto>.ReturnResultWith201(entityDto);
        }
    }
}