﻿using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class UpdateActivatedLicenseCommandHandler(ICompanyProfileRepository companyProfileRepository, IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<UpdateActivatedLicenseCommand, bool>
{
    public async Task<bool> Handle(UpdateActivatedLicenseCommand request, CancellationToken cancellationToken)
    {
        var companyProfile = await companyProfileRepository.All.FirstOrDefaultAsync();
        if (companyProfile == null)
        {
            return false; // Company profile not found
        }
        companyProfile.PurchaseCode = request.PurchaseCode;
        companyProfile.LicenseKey = request.LicenseKey;
        companyProfileRepository.Update(companyProfile);
        if (await _uow.SaveAsync() <= -1)
        {
            return false;
        }
        return true;
    }
}
