﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddComplaintCommandValidator : AbstractValidator<AddComplaintCommand>
    {
        public AddComplaintCommandValidator()
        {
            RuleFor(c => c.ComplaintTypeId).Must(d => d.GuidNotEmpty()).WithMessage("ComplaintType id is required");
            RuleFor(c => c.AssignedToId).Must(d => d.GuidNotEmpty()).WithMessage("AssignedTo id is required");
            RuleFor(c => c.Title).NotEmpty().WithMessage("Title is required");
        }
    }
    public static class Test
    {
        public static bool GuidNotEmpty(this Guid p)
        {
            return p != Guid.Empty;
        }
    }
}
