﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteComplaintCommandHandler (
        IComplaintRepository _complaintRepository,
          IUnitOfWork<QMSDbContext> _uow,
        ILogger<DeleteComplaintCommandHandler> _logger) : IRequestHandler<DeleteComplaintCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteComplaintCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entity = await _complaintRepository.All.Where(c => c.Id == request.Id).FirstOrDefaultAsync();
                if (entity == null)
                {
                    return ServiceResponse<bool>.Return404("risk not found");
                }
                _complaintRepository.Delete(entity);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while deleting Complaint");
                return ServiceResponse<bool>.Return500("Error while deleting Complaint");
            }

        }
    }
}
