﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateComplaintCommandValidator:AbstractValidator<UpdateComplaintCommand>
    {
        public UpdateComplaintCommandValidator()
        {
            RuleFor(c => c.Id).Must(c=>c.GuidNotEmpty()).WithMessage("Complaint id is required");
            RuleFor(c => c.ComplaintTypeId).Must(c => c.GuidNotEmpty()).WithMessage("ComplaintType id is required");
            RuleFor(c => c.AssignedToId).Must(c => c.GuidNotEmpty()).WithMessage("AssignedTo id is required");
            RuleFor(c => c.Title).NotEmpty().WithMessage("Title is required");
        }
    }
}
