﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllComplaintActionCommandHandler(
        IComplaintActionRepository _complaintActionRepository,
         IMapper _mapper,
        ILogger<GetAllComplaintActionCommandHandler> _logger) : IRequestHandler<GetAllComplaintActionCommand, ServiceResponse<List<ComplaintActionDto>>>
    {
        public async Task<ServiceResponse<List<ComplaintActionDto>>> Handle(GetAllComplaintActionCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entities = await _complaintActionRepository.All
                 .Include(c=>c.Responsible)
                 .Where(c => c.ComplaintId == request.ComplaintId).ToListAsync();
                var entitiesDto = _mapper.Map<List<ComplaintActionDto>>(entities);
                return ServiceResponse<List<ComplaintActionDto>>.ReturnResultWith200(entitiesDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while getting ComplaintActions.");
                return ServiceResponse<List<ComplaintActionDto>>.Return500("Error while getting ComplaintActions.");
            }
        }
    }
}
