﻿using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateComplaintActionCommand : IRequest<ServiceResponse<ComplaintActionDto>>
    {
        public required Guid Id { get; set; }
        public required Guid ComplaintId { get; set; }
        public string ActionTitle { get; set; }
        public string ActionDetail { get; set; }
        public Guid ResponsibleId { get; set; }
        public ComplaintStatusEnum Status { get; set; }
        public DateTime? DueDate { get; set; }
        public DateTime? CompletedDate { get; set; }
    }
}
