﻿using Amazon.Runtime.Internal.Util;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteComplaintAttachmentCommandHandler(
        IComplaintAttchmentRepository _complaintAttchmentRepository,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<DeleteComplaintAttachmentCommandHandler> _logger) : IRequestHandler<DeleteComplaintAttachmentCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteComplaintAttachmentCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entityExist = await _complaintAttchmentRepository.FindAsync(request.Id);
                if (entityExist == null)
                {
                    return ServiceResponse<bool>.ReturnFailed(404, "ComplaintAttachment not found.");
                }

                _complaintAttchmentRepository.Remove(entityExist);
                if (await _uow.SaveAsync() <= 0)
                {
                    return ServiceResponse<bool>.ReturnFailed(500, "Error while deleting Complaint Attachment.");
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while deleting Complaint attachment.");
                return ServiceResponse<bool>.ReturnFailed(500, "Error while deleting Complaint Attachments.");
            }
        }

    }
}
