﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Helper;
using QualityManagement.MediatR.RiskManagement;
using QualityManagement.Repository;
using QualityManagement.Repository.RiskManagment;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllComplaintAttachmentCommandHandler(

       IComplaintAttchmentRepository _complaintAttchmentRepository,
        IMapper _mapper,
        ILogger<GetAllComplaintAttachmentCommandHandler> _logger) : IRequestHandler<GetAllComplaintAttachmentCommand, ServiceResponse<List<ComplaintAttachmentDto>>>
    {
        public async Task<ServiceResponse<List<ComplaintAttachmentDto>>> Handle(GetAllComplaintAttachmentCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entity = await _complaintAttchmentRepository.All.Where(d => d.ComplaintId == request.ComplaintId).ToListAsync();
                var entityDto = _mapper.Map<List<ComplaintAttachmentDto>>(entity);
                return ServiceResponse<List<ComplaintAttachmentDto>>.ReturnResultWith201(entityDto);
            }
            catch (Exception ex)
            {
                _logger.LogError(ex, "Error occurred while getting Complaint attachment by capa request ID: {CapaRequestId}", request.ComplaintId);
                return ServiceResponse<List<ComplaintAttachmentDto>>.Return500("An error occurred while processing the request.");
            }
        }
    }
}
