﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddComplaintCommentCommandValidator:AbstractValidator<AddComplaintCommentCommand>
    {
        public AddComplaintCommentCommandValidator()
        {
            RuleFor(c => c.ComplaintId).Must(c => c.GuidNotEmpty()).WithMessage("Complaint id is required");
            RuleFor(c => c.CommentText).NotEmpty().WithMessage("comment text is required");
        }
    }
}
