﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllComplaintInvetigationCommandHandler (
        IComplaintInvestigationRepository _complaintInvestigationRepository,
        IMapper _mapper,
        ILogger<GetAllComplaintInvetigationCommandHandler> _logger) : IRequestHandler<GetAllComplaintInvetigationCommand, ServiceResponse<List<ComplaintInvestigationDto>>>
    {
        public async Task<ServiceResponse<List<ComplaintInvestigationDto>>> Handle(GetAllComplaintInvetigationCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entities = await _complaintInvestigationRepository.All
                    .Include(C=>C.Investigator)
                 .Where(c => c.ComplaintId == request.ComplaintId).ToListAsync();
                var entitiesDto = _mapper.Map<List<ComplaintInvestigationDto>>(entities);
                return ServiceResponse<List<ComplaintInvestigationDto>>.ReturnResultWith200(entitiesDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while getting ComplaintInvestigation.");
                return ServiceResponse<List<ComplaintInvestigationDto>>.Return500("Error while getting ComplaintInvestigation.");
            }
        }
    }
}
