﻿using MediatR;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetComplaintLogListCommandHandler(IComplaintLogRepository _complaintLogRepository) : IRequestHandler<GetComplaintLogListCommand, ComplaintLogList>
    {
        public async Task<ComplaintLogList> Handle(GetComplaintLogListCommand request, CancellationToken cancellationToken)
        {
            return await _complaintLogRepository.GetComplaintLog(request.ComplaintLogResource);
        }
    }
}
