﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllComplaintRootCauseCommandHandler(
        IComplaintRootCauseRepository _complaintRootCauseRepository,
        IMapper _mapper,
        ILogger<GetAllComplaintRootCauseCommandHandler> _logger) : IRequestHandler<GetAllComplaintRootCauseCommand, ServiceResponse<List<ComplaintRootCauseDto>>>
    {
        public async Task<ServiceResponse<List<ComplaintRootCauseDto>>> Handle(GetAllComplaintRootCauseCommand request, CancellationToken cancellationToken)
        {

            try
            {
                var entities = await _complaintRootCauseRepository.All
                 .Include(c=>c.CreatedBy)
                 .Where(c => c.ComplaintId == request.ComplaintId).ToListAsync();
                var entitiesDto = _mapper.Map<List<ComplaintRootCauseDto>>(entities);
                return ServiceResponse<List<ComplaintRootCauseDto>>.ReturnResultWith200(entitiesDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while getting Complaint Root Cause.");
                return ServiceResponse<List<ComplaintRootCauseDto>>.Return500("Error while getting Complaint Root Cuase.");
            }
        }
    }
}
