﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteComplaintTypeCommandHandler(
        IComplaintTypeRepository _complaintTypeRepository,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<DeleteComplaintTypeCommandHandler> _logger) : IRequestHandler<DeleteComplaintTypeCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteComplaintTypeCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entityExit = await _complaintTypeRepository.All
                   .FirstOrDefaultAsync(c => c.Id == request.Id);
                if (entityExit == null)
                {
                    return ServiceResponse<bool>.Return404();
                }
                _complaintTypeRepository.Remove(entityExit);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while deleting ComplaintType");
                return ServiceResponse<bool>.Return500("Error while deleting ComplaintType");
            }
        }
    }
}
