﻿using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class GetAllComplaintsCommandHandler(
   IComplaintTypeRepository _complaintTypeRepository,
    IMapper _mapper,
    ILogger<GetAllComplaintsCommandHandler> _logger) : IRequestHandler<GetAllComplaintsCommand, ServiceResponse<List<ComplaintTypeDto>>>
{
    public async Task<ServiceResponse<List<ComplaintTypeDto>>> Handle(GetAllComplaintsCommand request, CancellationToken cancellationToken)
    {

        try
        {
            var entities = await _complaintTypeRepository.All.ToListAsync(cancellationToken);
            var entitiesDto = _mapper.Map<List<ComplaintTypeDto>>(entities);
            return ServiceResponse<List<ComplaintTypeDto>>.ReturnResultWith200(entitiesDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while get All Complaints");
            return ServiceResponse<List<ComplaintTypeDto>>.Return500();
        }
    }
}
