﻿using System;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using MediatR;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace QualityManagement.MediatR;
public class AddSessionMediaCommand : IRequest<ServiceResponse<CourseSessionMediaDto>>
{
    public Guid CourseSessionId { get; set; }
    public string Name { get; set; }
    public string Description { get; set; }
    public string Url { get; set; }
    public string Extension { get; set; }
    public CourseSessionMediaType MediaType { get; set; }
    public StorageType StorageType { get; set; }
    [FromForm]
    public IFormFile Files { get; set; }
    public Guid StorageSettingId { get; set; }
}
