﻿using System.Threading;
using System.Threading.Tasks;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.Extensions.Logging;

namespace QualityManagement.MediatR;
public class DeleteSessionMediaCommandHandler(
    IUnitOfWork<QMSDbContext> unitOfWork,
    ICourseSessionMediaRepository courseSessionMediaRepository,
    ILogger<DeleteSessionMediaCommandHandler> logger)
    : IRequestHandler<DeleteSessionMediaCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(DeleteSessionMediaCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var sessionMedia = await courseSessionMediaRepository.FindAsync(request.Id);
            if (sessionMedia == null)
            {
                return ServiceResponse<bool>.ReturnFailed(404, "Media not found.");
            }

            courseSessionMediaRepository.Delete(sessionMedia);
            if (await unitOfWork.SaveAsync() <= 0)
            {
                return ServiceResponse<bool>.ReturnFailed(500, "Error while deleting media.");
            }
            return ServiceResponse<bool>.ReturnResultWith200(true);
        }
        catch (System.Exception ex)
        {
            logger.LogError(ex, "Error while deleting media.");
            return ServiceResponse<bool>.ReturnFailed(500, "Error while deleting media.");
        }
    }
}
