﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;

namespace QualityManagement.MediatR;
public class GetSessionMediaChunksCommandHandler(
        ICourseSessionMediaChunkRepository sessionMediaChunkRepository,
        IMapper mapper) : IRequestHandler<GetSessionMediaChunksCommand, ServiceResponse<List<CourseSessionMediaChunkDto>>>
{
    public async Task<ServiceResponse<List<CourseSessionMediaChunkDto>>> Handle(GetSessionMediaChunksCommand request, CancellationToken cancellationToken)
    {
        var documentChunks = await sessionMediaChunkRepository.All
            .Where(c => c.CourseSessionMediaId == request.SessionMediaId)
            .OrderBy(c => c.ChunkIndex)
            .ToListAsync();

        var documentChunksdto = mapper.Map<List<CourseSessionMediaChunkDto>>(documentChunks);

        return ServiceResponse<List<CourseSessionMediaChunkDto>>.ReturnResultWith200(documentChunksdto);

    }
}
