﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.Extensions.Logging;
using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class SaveCourseSessionQuizCommandHandler(
    ICourseSessionQuizRepository courseSessionQuizRepository,
    IUnitOfWork<QMSDbContext> unitOfWork,
    ILogger<SaveCourseSessionQuizCommandHandler> logger)
    : IRequestHandler<SaveCourseSessionQuizCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(SaveCourseSessionQuizCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var quiz = courseSessionQuizRepository.All
                .Where(d => d.CourseSessionId == request.CourseSessionId)
                .FirstOrDefault();

            if (quiz != null)
            {
                quiz.PassingScore = request.PassingScore;
                courseSessionQuizRepository.Update(quiz);
            }
            else
            {
                var newQuiz = new CourseSessionQuiz
                {
                    CourseSessionId = request.CourseSessionId,
                    Id = Guid.NewGuid(),
                    PassingScore = request.PassingScore,
                };
                courseSessionQuizRepository.Add(newQuiz);
            }

            if (await unitOfWork.SaveAsync() <= 0)
            {
                return ServiceResponse<bool>.ReturnFailed(500, "Error while saving quiz");
            }

            return ServiceResponse<bool>.ReturnResultWith200(true);
        }
        catch (Exception ex)
        {
            logger.LogError(ex, "Error while saving quiz");
            return ServiceResponse<bool>.ReturnFailed(500, "Error while saving quiz");
        }
    }
}
