﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.Extensions.Logging;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetCourseSessionCommandHandler(
    ICourseSessionRepository courseSessionRepository,
    ILogger<GetCourseSessionCommandHandler> logger,
    IMapper mapper)
    : IRequestHandler<GetCourseSessionCommand, ServiceResponse<CourseSessionDto>>
{
    public async Task<ServiceResponse<CourseSessionDto>> Handle(GetCourseSessionCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var courseSession = await courseSessionRepository.FindAsync(request.Id);
            if (courseSession == null)
            {
                return ServiceResponse<CourseSessionDto>.Return404("Course session not found");
            }

            return ServiceResponse<CourseSessionDto>.ReturnResultWith200(mapper.Map<CourseSessionDto>(courseSession));
        }
        catch (Exception ex)
        {
            logger.LogError(ex, "error while getting course session");
            return ServiceResponse<CourseSessionDto>.Return500("error while getting course session");
        }
    }
}
