﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.Extensions.Logging;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class ChangeCourseStatusCommandHandler(
    ICourseRepository courseRepository,
    IUnitOfWork<QMSDbContext> unitOfWork,
    ILogger<ChangeCourseStatusCommandHandler> logger)
    : IRequestHandler<ChangeCourseStatusCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(ChangeCourseStatusCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var course = await courseRepository.FindAsync(request.Id);
            if (course == null)
            {
                return ServiceResponse<bool>.Return404();
            }

            course.CourseStatus = request.CourseStatus;
            courseRepository.Update(course);

            if (await unitOfWork.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            return ServiceResponse<bool>.ReturnResultWith204();
        }
        catch (System.Exception ex)
        {
            logger.LogError(ex, "Error while updating course status");
            return ServiceResponse<bool>.Return500("Error while updating course status");
        }
    }
}
