﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.Extensions.Logging;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class DeleteCourseCommandHandler(
    ICourseRepository courseRepository,
    ILogger<DeleteCourseCommandHandler> logger,
    IUnitOfWork<QMSDbContext> unitOfWork)
    : IRequestHandler<DeleteCourseCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(DeleteCourseCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var course = await courseRepository.FindAsync(request.Id);
            if (course == null)
            {
                return ServiceResponse<bool>.Return404();
            }

            courseRepository.Delete(course);
            if (await unitOfWork.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            return ServiceResponse<bool>.ReturnResultWith204();
        }
        catch (System.Exception ex)
        {
            logger.LogError(ex, "Error while deleting course");
            return ServiceResponse<bool>.Return500("Error while deleting course");
        }
    }
}
