﻿using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetCourseForDropdownCommandHandler(
    ICourseRepository courseRepository,
    ILogger<GetCourseForDropdownCommandHandler> logger)
    : IRequestHandler<GetCourseForDropdownCommand, List<IdNameDto>>
{
    public async Task<List<IdNameDto>> Handle(GetCourseForDropdownCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var course = await courseRepository.All.Where(c => EF.Functions.Like(c.Title, $"%{request.Query}%"))
                .Select(d => new
                    IdNameDto
                {
                    Id = d.Id,
                    Name = d.Title
                }).Take(10)
                .ToListAsync();
            return course;
        }
        catch (Exception ex)
        {
            logger.LogError(ex, "Error occurred while handling GetCourseForDropdownCommand");
            return [];
        }
        throw new System.NotImplementedException();
    }
}
