﻿using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetTotalUserCountQueryHandler(IUserRepository userRepository)
        : IRequestHandler<GetTotalUserCountQuery, int>
    {
        public async Task<int> Handle(GetTotalUserCountQuery request, CancellationToken cancellationToken)
        {
            return await userRepository.All.CountAsync(cancellationToken);
        }
    }
}
