﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class DbMigrationCommandHandler : IRequestHandler<DbMigrationCommand, bool>
{

    private readonly IUnitOfWork<QMSDbContext> _uow;
    public DbMigrationCommandHandler(
        IUnitOfWork<QMSDbContext> uow
        )
    {
        _uow = uow;
    }
    public async Task<bool> Handle(DbMigrationCommand request, CancellationToken cancellationToken)
    {
        await _uow.Context.Database.MigrateAsync();
        return true;
    }
}