﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Linq;
using System.Linq.Dynamic.Core;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddDepartmentCommandHandler(
        IDepartmentRepository _departmentRepository,
        IMapper _mapper,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<AddDepartmentCommandHandler> _logger) : IRequestHandler<AddDepartmentCommand, ServiceResponse<DepartmentDto>>
    {
        public async Task<ServiceResponse<DepartmentDto>> Handle(AddDepartmentCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var existingEntity = await _departmentRepository.All
                    .Where(d => d.Name.ToLower() == request.Name.ToLower()).FirstOrDefaultAsync();
                if (existingEntity != null)
                {
                    return ServiceResponse<DepartmentDto>.Return409("Department name is already exist");
                }
                var entity = _mapper.Map<Department>(request);
                _departmentRepository.Add(entity);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<DepartmentDto>.Return500();
                }
                var entityDto = _mapper.Map<DepartmentDto>(entity);
                return ServiceResponse<DepartmentDto>.ReturnResultWith201(entityDto);

            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while saving Department");
                return ServiceResponse<DepartmentDto>.Return500("Error while saving Department");
            }
        }
    }
}

