﻿using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteDepartmentCommandHandler(IDepartmentRepository _departmentRepository,
        ILogger<DeleteDepartmentCommandHandler> _logger,
        IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<DeleteDepartmentCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteDepartmentCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entityExist = await _departmentRepository.FindAsync(request.Id);
                if (entityExist == null)
                {
                    return ServiceResponse<bool>.Return404();
                }
                _departmentRepository.Remove(entityExist);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while Deleting Department");
                return ServiceResponse<bool>.Return500("Error While Deleting Department");
            }

        }
    }
}
