﻿using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteDocumentCommentCommandHandler(
        IDocumentCommentRepository _documentCommentRepository,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<DeleteDocumentCommentCommandHandler> _logger) : IRequestHandler<DeleteDocumentCommentCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteDocumentCommentCommand request, CancellationToken cancellationToken)
        {
            var documentCommentEntity = await _documentCommentRepository.FindAsync(request.Id);
            if (documentCommentEntity != null)
            {
                _documentCommentRepository.Remove(documentCommentEntity);
                if (await _uow.SaveAsync() <= 0)
                {
                    _logger.LogError("Error while adding industry");
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            return ServiceResponse<bool>.Return404();
        }
    }
}
