﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;

public class GetDocumentCommentByIdQueryHandler(
    IDocumentCommentRepository _documentCommentRepository) : IRequestHandler<GetDocumentCommentByIdQuery, List<DocumentCommentDto>>
{
    public async Task<List<DocumentCommentDto>> Handle(GetDocumentCommentByIdQuery request, CancellationToken cancellationToken)
    {
        var documentComment = await _documentCommentRepository.All
            .Include(c => c.CreatedByUser)
            .Where(c => c.DocumentId == request.DocumentId)
            .Select(c => new DocumentCommentDto
            {
                Id = c.Id,
                CreatedBy = $"{c.CreatedByUser.FirstName} {c.CreatedByUser.LastName}",
                CreatedDate = c.CreatedDate,
                Comment = c.Comment,
                DocumentId = c.DocumentId
            })
            .ToListAsync();
        return documentComment;
    }
}
