﻿using MediatR;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;

public class GetDocumentLibraryQueryHandler(
    IDocumentRepository _documentRepository) : IRequestHandler<GetDocumentLibraryQuery, DocumentList>
{
    public async Task<DocumentList> Handle(GetDocumentLibraryQuery request, CancellationToken cancellationToken)
    {
        return await _documentRepository.GetDocumentsLibrary(request.Email, request.DocumentResource);
    }
}
