﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Repository;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class CheckDocumentLinkPasswordCommandHandler(
        IDocumentShareableLinkRepository _documentShareableLinkRepository)
        : IRequestHandler<CheckDocumentLinkPasswordCommand, bool>
    {
        public async Task<bool> Handle(CheckDocumentLinkPasswordCommand request, CancellationToken cancellationToken)
        {
            var link = await _documentShareableLinkRepository.All.FirstOrDefaultAsync(c => c.Id == request.Id);
            if (link == null)
            {
                return false;
            }

            var base64EncodedBytes = Convert.FromBase64String(link.Password);
            var password = System.Text.Encoding.UTF8.GetString(base64EncodedBytes);
            return password == request.Password;
        }
    }
}
