﻿using MediatR;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteDocumentShareableLinkCommandHandler
        (IDocumentShareableLinkRepository _documentShareableLinkRepository,
         IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<DeleteDocumentShareableLinkCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteDocumentShareableLinkCommand request, CancellationToken cancellationToken)
        {
            var link = await _documentShareableLinkRepository.FindAsync(request.Id);
            if (link == null)
            {
                return ServiceResponse<bool>.Return404();
            }
            _documentShareableLinkRepository.Remove(link);
            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            return ServiceResponse<bool>.ReturnSuccess();
        }
    }
}
