﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetDocumentShareableLinkQueryHandler
        (IDocumentShareableLinkRepository _documentShareableLinkRepository,
         IMapper _mapper) : IRequestHandler<GetDocumentShareableLinkQuery, DocumentShareableLinkDto>
    {

        public async Task<DocumentShareableLinkDto> Handle(GetDocumentShareableLinkQuery request, CancellationToken cancellationToken)
        {
            var link = await _documentShareableLinkRepository.All.FirstOrDefaultAsync(c => c.DocumentId == request.Id);
            if (link == null)
            {
                return new DocumentShareableLinkDto { };
            }

            var result = _mapper.Map<DocumentShareableLinkDto>(link);
            if (!string.IsNullOrWhiteSpace(result.Password))
            {
                var base64EncodedBytes = Convert.FromBase64String(result.Password);
                result.Password = System.Text.Encoding.UTF8.GetString(base64EncodedBytes);
            }
            return result;
        }
    }
}
