﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllDocumentStatusCommandHandler(IDocumentStatusRepository _documentStatusRepository, IMapper _mapper) : IRequestHandler<GetAllDocumentStatusQuery, ServiceResponse<List<DocumentStatusDto>>>
    {

        public async Task<ServiceResponse<List<DocumentStatusDto>>> Handle(GetAllDocumentStatusQuery request, CancellationToken cancellationToken)
        {
            var entities = await _documentStatusRepository.All.ToListAsync(cancellationToken);
            var dtos = _mapper.Map<List<DocumentStatusDto>>(entities);
            return ServiceResponse<List<DocumentStatusDto>>.ReturnResultWith200(dtos);
        }
    }
}
