﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Repository;
using MediatR;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteDocumentTokenCommandHandler(
        IDocumentTokenRepository _documentTokenRepository,
        IUnitOfWork<QMSDbContext> _uow)
        : IRequestHandler<DeleteDocumentTokenCommand, bool>
    {
        public async Task<bool> Handle(DeleteDocumentTokenCommand request, CancellationToken cancellationToken)
        {
            var documentToken = _documentTokenRepository.All.FirstOrDefault(c => c.Token == request.Token);
            if (documentToken != null)
            {
                _documentTokenRepository.Remove(documentToken);
                await _uow.SaveAsync();
            }
            return true;
        }
    }
}
