﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetDocumentPathByTokenCommandHandler(
        IDocumentTokenRepository _documentTokenRepository,
        IDocumentShareableLinkRepository _documentShareableLinkRepository) : IRequestHandler<GetDocumentPathByTokenCommand, bool>
    {
        public async Task<bool> Handle(GetDocumentPathByTokenCommand request, CancellationToken cancellationToken)
        {
            var documentId = request.Id;
            if (request.IsPublic)
            {
                var link = await _documentShareableLinkRepository.All.FirstOrDefaultAsync(c => c.LinkCode == request.Id.ToString());
                if (link == null)
                {
                    return false;
                }
                documentId = link.DocumentId;
            }

            if (await _documentTokenRepository.All.AnyAsync(c => c.DocumentId == documentId && c.Token == request.Token))
            {
                return true;
            }

            return false;
        }
    }
}
