﻿using AutoMapper;
using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetDocumentByIdQueryHandler(
        IDocumentRepository _documentRepository,
        IMapper _mapper
        ) : IRequestHandler<GetDocumentByIdQuery, DocumentDto>
    {
        public async Task<DocumentDto> Handle(GetDocumentByIdQuery request, CancellationToken cancellationToken)
        {
            var document = await _documentRepository.FindAsync(request.Id);
            var documentDto = _mapper.Map<DocumentDto>(document);
            return documentDto;
        }
    }
}
