﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetEmailTemplateQueryHandler(
        IEmailTemplateRepository emailTemplateRepository,
        IMapper mapper,
        ILogger<GetEmailTemplateQueryHandler> logger
        ) : IRequestHandler<GetEmailTemplateQuery, ServiceResponse<EmailTemplateDto>>
    {
        public async Task<ServiceResponse<EmailTemplateDto>> Handle(GetEmailTemplateQuery request, CancellationToken cancellationToken)
        {
            var emailTemplate = await emailTemplateRepository.FindBy(c => c.Id == request.Id)
                .FirstOrDefaultAsync(cancellationToken);

            if (emailTemplate == null)
            {
                logger.LogError("Email Template is not available");
                return ServiceResponse<EmailTemplateDto>.Return404();
            }

            return ServiceResponse<EmailTemplateDto>.ReturnResultWith200(mapper.Map<EmailTemplateDto>(emailTemplate));
        }
    }
}
