﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetEmailSMTPSettingsQueryHandler(
        IEmailSMTPSettingRepository _emailSMTPSettingRepository,
        IMapper _mapper) : IRequestHandler<GetEmailSMTPSettingsQuery, List<EmailSMTPSettingDto>>
    {
        public async Task<List<EmailSMTPSettingDto>> Handle(GetEmailSMTPSettingsQuery request, CancellationToken cancellationToken)
        {
            var entities = await _emailSMTPSettingRepository.All.ToListAsync();
            entities.ForEach(c => c.Password = "*****");
            return _mapper.Map<List<EmailSMTPSettingDto>>(entities);
        }
    }
}
