﻿using AutoMapper;
using MediatR;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class SendEmailCommandHandler(
         ISendEmailRepository _sendEmailRepository,
         UserInfoToken _userInfoToken,
         IMapper _mapper,
         IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<SendEmailCommand, bool>
    {
        public async Task<bool> Handle(SendEmailCommand request, CancellationToken cancellationToken)
        {
            var sendEmail = _mapper.Map<SendEmail>(request);
            sendEmail.FromEmail = _userInfoToken.Email;
            sendEmail.IsSend = false;
            _sendEmailRepository.Add(sendEmail);
            if (await _uow.SaveAsync() <= -1)
            {
                return false;
            }
            return true;
        }
    }
}
