﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
internal class GetEmployeeCourseSessionByCourseIdCommandHandler(
    IEmployeeCourseSessionRepository employeeCourseSessionRepository,
    ILogger<List<GetEmployeeCourseSessionByCourseIdCommand>> logger
    ) : IRequestHandler<GetEmployeeCourseSessionByCourseIdCommand, ServiceResponse<List<EmployeeAssignedCourseSessionDto>>>
{
    public async Task<ServiceResponse<List<EmployeeAssignedCourseSessionDto>>> Handle(GetEmployeeCourseSessionByCourseIdCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var employeeCourseSession = await employeeCourseSessionRepository
                                        .All
                                        .Include(d => d.CourseSession)
                                        .Include(d => d.EmployeeCourseSessionQuiz)
                                        .Where(d => d.CourseSession.CourseId == request.CourseId
                                            && d.EmployeeId == request.EmployeeId)
                                        .Select(employeeCourseSession => new EmployeeAssignedCourseSessionDto
                                        {
                                            Id = employeeCourseSession.Id,
                                            SessionName = employeeCourseSession.CourseSession.Title,
                                            CompletedDate = employeeCourseSession.CompletedDate,
                                            Result = employeeCourseSession.IsPassed,
                                            ScorePercentage = employeeCourseSession.EmployeeCourseSessionQuiz.ScorePercentage
                                        }).ToListAsync();

            return ServiceResponse<List<EmployeeAssignedCourseSessionDto>>.ReturnResultWith200(employeeCourseSession);
        }
        catch (Exception ex)
        {
            logger.LogError(ex, "Error occurred while getting employee course session.");
            return ServiceResponse<List<EmployeeAssignedCourseSessionDto>>.Return500("An error occurred while getting employee course session.");
        }
    }
}
