﻿using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetAssignedEmployeeCoursesCommandHandler(
    IEmployeeCourseRepository employeeCourseRepository,
    UserInfoToken userInfoToken
    ) : IRequestHandler<GetAssignedEmployeeCoursesCommand, AssignedEmployeeCourseList>
{
    public async Task<AssignedEmployeeCourseList> Handle(GetAssignedEmployeeCoursesCommand request, CancellationToken cancellationToken)
    {
        if (!request.AssignedEmployeeCourseResource.UserId.HasValue && !request.AssignedEmployeeCourseResource.CourseId.HasValue)
        {
            request.AssignedEmployeeCourseResource.UserId = userInfoToken.Id;
        }

        return await employeeCourseRepository.GetAssignedEmployeesCourses(request.AssignedEmployeeCourseResource);
    }
}






