﻿using MediatR;
using QualityManagement.Helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAssignedEmployeeCoursesStatusCountCommand:IRequest<ServiceResponse<CoursesStatusCountDto>>
    {
        public Guid CourseId { get; set; }
    }

    public class CoursesStatusCountDto
    {
        public int CoursesCompleteCount {  get; set; }
        public int CoursesInProgressCount {  get; set; }
        public int CoursesPendingCount {  get; set; }
        public int TotalCount  => CoursesCompleteCount + CoursesInProgressCount + CoursesPendingCount;
    }
}
