﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetFileRequestDocumentTokanQueryHandler(IDocumentTokenRepository _documentTokenRepository, IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<GetFileRequestDocumentTokenQuery, string>
    {
        public async Task<string> Handle(GetFileRequestDocumentTokenQuery request, CancellationToken cancellationToken)
        {
            var token = Guid.NewGuid();
            var documentToken = await _documentTokenRepository.All.FirstOrDefaultAsync(c => c.DocumentId == request.Id);
            if (documentToken == null)
            {
                _documentTokenRepository.Add(new DocumentToken
                {
                    CreatedDate = DateTime.UtcNow,
                    DocumentId = request.Id,
                    Token = token
                });
                await _uow.SaveAsync();
            }
            else
            {
                token = documentToken.Token;
            }
            return token.ToString();
        }
    }
}
